﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace ITA_580
{
    public partial class Form1
    {
        private void ShowIgnitionTime()
        {
            byte res;
            byte typ;
            byte[] buf = new byte[32];

            //on delay time
            typ = 1;
            buf[0] = 0x55;
            buf[1] = 0xC1;
            buf[2] = 0;
            buf[3] = 1;
            buf[4] = 0;
            res = AecPassThruCommand(gPtrAecInit, typ, buf);
            if (res != 0)
            {
                MessageBox.Show("Get Ignition On Delay Time Error ", "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
            else
            {
                comboBox1.SelectedIndex = buf[4];
            }

            //off delay time
            typ = 1;
            buf[0] = 0x55;
            buf[1] = 0xC2;
            buf[2] = 0;
            buf[3] = 1;
            buf[4] = 0;
            res = AecPassThruCommand(gPtrAecInit, typ, buf);
            if (res != 0)
            {
                MessageBox.Show("Get Ignition Off Delay Time Error ", "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
            else
            {
                comboBox2.SelectedIndex = buf[4];
            }

            //hard off delay time
            typ = 1;
            buf[0] = 0x55;
            buf[1] = 0xC3;
            buf[2] = 0;
            buf[3] = 1;
            buf[4] = 0;
            res = AecPassThruCommand(gPtrAecInit, typ, buf);
            if (res != 0)
            {
                MessageBox.Show("Get Ignition Off Delay Time Error ", "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
            else
            {
                comboBox3.SelectedIndex = buf[4];
            }
        }

        private byte CheckIgnitionControlMode()
        {
            byte res;
            byte typ;
            byte[] buf = new byte[32];

            typ = 1;
            buf[0] = 0x55;
            buf[1] = 0xC0;
            buf[2] = 0;
            buf[3] = 1;
            buf[4] = 0;
            res = AecPassThruCommand(gPtrAecInit, typ, buf);
            if (res != 0)
            {
                MessageBox.Show("Get Ignition Power Control Mode Error ", "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
                return 0xFF;
            }
            else
            {
                return buf[4];
            }
        }

        private void SetIgnitionControlMode(byte sts)
        {
            byte err = 0;
            byte res;
            byte typ;
            byte[] buf = new byte[32];

            //set power control mode
            typ = 0;
            buf[0] = 0x54;
            buf[1] = 0xC0;
            buf[2] = 0;
            buf[3] = 1;
            buf[4] = sts;
            res = AecPassThruCommand(gPtrAecInit, typ, buf);
            if (res != 0)
            {
                MessageBox.Show("Set Ignition Power Control Mode Error ", "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
                err = 1;
            }

            if (sts == 1)   //enable
            {
                //set on delay time
                typ = 0;
                buf[0] = 0x54;
                buf[1] = 0xC1;
                buf[2] = 0;
                buf[3] = 1;
                buf[4] = (byte)comboBox1.SelectedIndex;
                res = AecPassThruCommand(gPtrAecInit, typ, buf);
                if (res != 0)
                {
                    MessageBox.Show("Set Ignition On Delay Time Error ", "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
                    err = 1;
                }

                //set off delay time
                typ = 0;
                buf[0] = 0x54;
                buf[1] = 0xC2;
                buf[2] = 0;
                buf[3] = 1;
                buf[4] = (byte)comboBox2.SelectedIndex;
                res = AecPassThruCommand(gPtrAecInit, typ, buf);
                if (res != 0)
                {
                    MessageBox.Show("Set Ignition Off Delay Time Error ", "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
                    err = 1;
                }

                //set hard off delay time
                typ = 0;
                buf[0] = 0x54;
                buf[1] = 0xC3;
                buf[2] = 0;
                buf[3] = 1;
                buf[4] = (byte)comboBox3.SelectedIndex;
                res = AecPassThruCommand(gPtrAecInit, typ, buf);
                if (res != 0)
                {
                    MessageBox.Show("Set Ignition Hard Off Delay Time Error ", "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
                    err = 1;
                }
            }
           
            if (err == 0)
            {
                MessageBox.Show("OK");
            }
        }

        private void ShowIgnitionStatus()
        {
            byte res;
            byte typ;
            byte[] buf = new byte[32];

            typ = 1;
            buf[0] = 0x55;
            buf[1] = 0xC6;
            buf[2] = 0;
            buf[3] = 1;
            buf[4] = 0;
            res = AecPassThruCommand(gPtrAecInit, typ, buf);
            if (res != 0)
            {
                MessageBox.Show("Get Ignition Status Error ", "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
            else
            {
                if (buf[4] == 0)    //inactive
                {
                    label17.Text = "IGN# Inactive";
                }
                else if (buf[4] == 1)    //active
                {
                    label17.Text = "IGN# Active";
                }
            }
        }

        private void ShowIgnition()
        {
            if (CtlByBIOS.Checked == true)  //BIOS
            {
                radioButton1.Enabled = false;
                radioButton2.Enabled = false;
                label14.Enabled = false;
                comboBox1.Enabled = false;
                label15.Enabled = false;
                comboBox2.Enabled = false;
                label16.Enabled = false;
                comboBox3.Enabled = false;
                label17.Enabled = false;
                button2.Enabled = false;
            }
            else  //software
            {
                radioButton1.Enabled = true;
                radioButton2.Enabled = true;
                label17.Enabled = true;
                button2.Enabled = true;

                //check ign status
                if (CheckIgnitionControlMode() == 1) //enable
                {
                    radioButton1.Checked = false;
                    radioButton2.Checked = true;

                    label14.Enabled = true;
                    comboBox1.Enabled = true;
                    label15.Enabled = true;
                    comboBox2.Enabled = true;
                    label16.Enabled = true;
                    comboBox3.Enabled = true;
                }
                else //disable
                {
                    radioButton1.Checked = true;
                    radioButton2.Checked = false;

                    comboBox1.Enabled = false;
                    comboBox2.Enabled = false;
                    comboBox3.Enabled = false;
                }

                ShowIgnitionTime();
                ShowIgnitionStatus();
            }
        }

        private void CheckIgnitionControl()
        {
            byte res;
            byte typ;
            byte[] buf = new byte[32];

            typ = 1;
            buf[0] = 0x55;
            buf[1] = 0xC4;
            buf[2] = 0;
            buf[3] = 1;
            buf[4] = 0;
            res = AecPassThruCommand(gPtrAecInit, typ, buf);
            if (res != 0)
            {
                MessageBox.Show("Get Ignition Control Mode Error ", "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }

            if (buf[4] == 1)    //software
            {
                CtlByBIOS.Checked = false;
            }
            else    //BIOS
            {
                CtlByBIOS.Checked = true;
            }
        }

        private void SetIgnitionControl()
        {
            byte res;
            byte typ;
            byte[] buf = new byte[32];

            typ = 0;
            buf[0] = 0x54;
            buf[1] = 0xC4;
            buf[2] = 0;
            buf[3] = 1;
            if (CtlByBIOS.Checked == false) //software
            {
                buf[4] = 1;
            }
            else //BIOS
            {
                buf[4] = 0;
            }

            res = AecPassThruCommand(gPtrAecInit, typ, buf);
            if (res != 0)
            {
                MessageBox.Show("Switch Ignition Control Mode Error ", "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
                CtlByBIOS.Checked = !CtlByBIOS.Checked;
            }
        }
    }
}
